#On importe les modules de l'application
import folium
import pandas
import requests
import seaborn

#On declare les fonctions
def apiAdresse(uneAdresse, codePostal):
    #On utilise l'API adresse en reutilisant l'adresse trouvee dans le datafrale final et le code postal
    urlApi = "https://api-adresse.data.gouv.fr/search/?q="+str(uneAdresse)+"&postcode="+codePostal
    contenu = requests.get(urlApi)
    data = contenu.json()
    
    return data

#On creer le premier dataframe qui va contenir toutes les auto ecoles
dfAutoEcoles = pandas.read_excel('autoEcoles.xls', sheet_name='Feuille1')

#On demande a l'utilisateur de choisir une ville
villeChoisie = str.upper(input("Choisissez votre ville :"))

#On met un try pour mettre un message d'erreur personnalise
try:

    #On creer le dataframe final qui va contenir toutes les auto ecoles de la ville que l'utilisateur a saisie
    dfFinal = dfAutoEcoles[dfAutoEcoles['Ville'] == villeChoisie]
    
    #On creer le dataframe qui va etre utiliser pour le graphique de comparaison des taux de reussite
    #dfVillesExPoitouCharentes = dfAutoEcoles[dfAutoEcoles['Ville'] == "LA ROCHELLE" or "NIORT" or "POITIERS" or "ANGOULEME"]
    
    #On reinitialise les index du dataframe
    dfFinal = dfFinal.reset_index()
    
    #Indice a 0 qui va permettre d'initier le parcours du dataframe final
    i = 0
    
    #On creer 2 nouvelles colonnes dans le dataframe
    dfFinal['Latitude'] = ""
    dfFinal['Longitude'] = ""
    
    #Pour chaque adresse dans le dataframe final
    for uneAdresse in dfFinal['Adresse']:
        
        #On garde le code postal de la ville pour avoir plus de precision dans la recherche avec l'API
        codePostal = dfFinal['CP'][i]
        
        #On utilise la fonction API Adresse
        data = apiAdresse(uneAdresse, codePostal)
            
        #On va chercher la longitude et la latitude de l'auto ecole
        longitude = data['features'][0]['geometry']['coordinates'][0]
        latitude = data['features'][0]['geometry']['coordinates'][1]
                
        #On va sauvegarder la longitude et la latitude de l'auto ecole dans le dataframe final
        dfFinal['Latitude'][i] = latitude
        dfFinal['Longitude'][i] = longitude
            
        #Pour passer a l'auto ecole suivante dans le dataframe final, on incremente l'indice
        i = i + 1
        
    #On enleve les valeurs manquantes dans la latitude et la longitude
    dfFinal = dfFinal.dropna(subset = ['Longitude', 'Latitude'])
        
    #On initialise les indicateurs pour afficher les icones sur la carte
    centre = dfFinal[['Latitude', 'Longitude']].mean().values.tolist()
    so = dfFinal[['Latitude', 'Longitude']].min().values.tolist()
    ne = dfFinal[['Latitude', 'Longitude']].max().values.tolist()
    
    #On declare la carte avec la ville que l'utilisateur a choisie par defaut
    m = folium.Map(location = centre)
    
    #On remet a 0 l'indice
    i = 0
    
    #Pour taux dans le dataframe final, on affiche un marqueur sur la carte
    #On ecrit egalement des informations (adresse, nom...) de l'auto ecole
    for unTaux in dfFinal['B TR']:
            
        #On supprime les eventuels caracteres speciaux dans le taux de reussite et on le converti en float
        txPermisB = str(unTaux)
        txPermisB = txPermisB.replace("%","")
        txPermisB = txPermisB.replace(",",".")
        txPermisB = float(txPermisB)
            
        #On gere les couleurs des icones
        if txPermisB < 25:
            couleur = "red"
        elif txPermisB >= 25 and txPermisB < 50:
            couleur = "orange"
        else:
            couleur = "green"
                        
        #Pour chaque autoecole, on affiche un marqueur sur la carte
        folium.Marker([dfFinal.iloc[i]['Latitude'], dfFinal.iloc[i]['Longitude']],
                popup=folium.Popup("<b>Nom </b>: "+str(dfFinal.iloc[i]['Raison Sociale'])+"<br/><b>Adresse </b>: "+str(dfFinal.iloc[i]['Adresse'])+", "+str(dfFinal.iloc[i]['CP'])+" "+str(dfFinal.iloc[i]['Ville'])+"<br/><b>Taux de réussite :</b> "+str(dfFinal.iloc[i]['B TR']),max_width = 400),
                icon=folium.Icon(color=couleur, icon="home")).add_to(m)
                    
        i = i + 1
               
        #Quand le compteur interne arrive a la derniere ligne du dataframe, alors on arrete
        while i == len(dfFinal):
            break
    
    #On affecte les indicateurs a la carte
    m.fit_bounds([so, ne])
    
    #On sauvegarde la carte dans le repertoire racine de l'application sous le fichier carteApi.html
    m.save('carteApi.html')
    
    #Diagramme de comparaison des taux de reussite des villes la rochelle, niort, poitiers et angouleme
    #seaborn.catplot(x = "cut", data = dfVillesExPoitouCharentes.iloc[i]['B TR'], kind = "count").set(title="Distribution des taux de réussite par ville de l'ex région Poitou-charentes", xlabel="Ville", ylabel="Taux de réussite")
    
    #On affiche un message confirmant la creation de la carte html
    print("La carte a bien été généree.")
    
except:
    print("Une erreur dans la saisie de votre ville s'est produite. Veuillez réessayer.")